const
  cifra : array [0..4] of integer = (0,1,2,5,8);
  ogledalo : array [0..4] of integer = (0,1,3,2,4);

type
  TBroj = array [1..21] of integer;

var
  g1,g2 : TBroj;
  n1,n2 : integer;
  f : text;
  s : longint;
  i,poc,kraj,br : integer;

procedure ucitaj;
var
  c : char;
  cifre : set of char;
begin
  assign(f,'ogledalo.in'); reset(f);
  cifre := ['0'..'9'];
  n1 := 0; n2 := 0;

  read(f,c);
  while c <> ' ' do begin
    n1 := n1 + 1;
    g1[n1] := ord(c) - 48;
    read(f,c);
  end;

  read(f,c);
  while c in cifre do begin
    n2 := n2 + 1;
    g2[n2] := ord(c) - 48;
    read(f,c);
  end;
  close(f);
end;

function manji(var a,b : TBroj; n : integer) : boolean;
var
  i : integer;
  u : boolean;
begin
  u := true; i := n;
  while u and (i > 0) do begin
    u := cifra[a[i]] <= b[i];
    i := i - 1;
  end;
  manji := u;
end;

procedure povecaj(var b : TBroj; n : integer);
var
  i : integer;
begin
  i := n div 2 + 1;
  b[i] := b[i] + 1;
  if b[i] = 5 then begin
    b[i] := 1;
    i := i + 1;
    b[i] := b[i] + 1;
  end;
  while b[i] = 5 do begin
    i := i + 1;
    b[i] := b[i] + 1;
  end;
  for i :=1 to n div 2 do
    b[i] := ogledalo[b[n-i+1]];
end;

function izbroji(var a : TBroj; n : integer) : integer;
var
  b : TBroj;
  i,br : integer;
begin
  b[n] := 1;
  for i := n-1 downto 2 do b[i] := 0;
  b[1] := 1;
  br := 0;
  while manji(b,a,n) do begin
    br := br + 1;
    povecaj(b,n);
  end;
  izbroji := br;
end;

begin
  ucitaj;
  s := 1;
  for i := 1 to n1 div 2 do
    s := s * 5;
  for i := n1 to (n2-1) do
    if i mod 2 = 0 then
      br := br + s
    else begin
      br := br + s * 3;
      s := s * 5;
    end;
  assign(f,'ogledalo.out'); rewrite(f);
  poc := izbroji(g1,n1);
  kraj := izbroji(g2,n2);
  writeln(f,br - poc + kraj);
  close(f);
end.

